"use strict";
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name in all)
    __defProp(target, name, { get: all[name], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var BookmarkShapeUtil_exports = {};
__export(BookmarkShapeUtil_exports, {
  BookmarkShapeUtil: () => BookmarkShapeUtil,
  getHumanReadableAddress: () => getHumanReadableAddress
});
module.exports = __toCommonJS(BookmarkShapeUtil_exports);
var import_jsx_runtime = require("react/jsx-runtime");
var import_editor = require("@tldraw/editor");
var import_HyperlinkButton = require("../shared/HyperlinkButton");
var import_icons_editor = require("../shared/icons-editor");
var import_rotated_box_shadow = require("../shared/rotated-box-shadow");
const BOOKMARK_WIDTH = 300;
const BOOKMARK_HEIGHT = 320;
const BOOKMARK_JUST_URL_HEIGHT = 46;
const SHORT_BOOKMARK_HEIGHT = 101;
class BookmarkShapeUtil extends import_editor.BaseBoxShapeUtil {
  static type = "bookmark";
  static props = import_editor.bookmarkShapeProps;
  static migrations = import_editor.bookmarkShapeMigrations;
  canResize = () => false;
  hideSelectionBoundsFg = () => true;
  getDefaultProps() {
    return {
      url: "",
      w: BOOKMARK_WIDTH,
      h: BOOKMARK_HEIGHT,
      assetId: null
    };
  }
  component(shape) {
    const asset = shape.props.assetId ? this.editor.getAsset(shape.props.assetId) : null;
    const pageRotation = this.editor.getShapePageTransform(shape).rotation();
    const address = getHumanReadableAddress(shape);
    return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_editor.HTMLContainer, { children: /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(
      "div",
      {
        className: "tl-bookmark__container",
        style: {
          boxShadow: (0, import_rotated_box_shadow.getRotatedBoxShadow)(pageRotation),
          maxHeight: shape.props.h
        },
        children: [
          (!asset || asset.props.image) && /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: "tl-bookmark__image_container", children: [
            asset ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
              "img",
              {
                className: "tl-bookmark__image",
                draggable: false,
                referrerPolicy: "strict-origin-when-cross-origin",
                src: asset?.props.image,
                alt: asset?.props.title || ""
              }
            ) : /* @__PURE__ */ (0, import_jsx_runtime.jsx)("div", { className: "tl-bookmark__placeholder" }),
            asset?.props.image && /* @__PURE__ */ (0, import_jsx_runtime.jsx)(import_HyperlinkButton.HyperlinkButton, { url: shape.props.url, zoomLevel: this.editor.getZoomLevel() })
          ] }),
          /* @__PURE__ */ (0, import_jsx_runtime.jsxs)("div", { className: "tl-bookmark__copy_container", children: [
            asset?.props.title ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)("h2", { className: "tl-bookmark__heading", children: asset.props.title }) : null,
            asset?.props.description && asset?.props.image ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)("p", { className: "tl-bookmark__description", children: asset.props.description }) : null,
            /* @__PURE__ */ (0, import_jsx_runtime.jsxs)(
              "a",
              {
                className: "tl-bookmark__link",
                href: shape.props.url || "",
                target: "_blank",
                rel: "noopener noreferrer",
                onPointerDown: import_editor.stopEventPropagation,
                onPointerUp: import_editor.stopEventPropagation,
                onClick: import_editor.stopEventPropagation,
                children: [
                  asset?.props.favicon ? /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
                    "img",
                    {
                      className: "tl-bookmark__favicon",
                      src: asset?.props.favicon,
                      referrerPolicy: "strict-origin-when-cross-origin",
                      alt: `favicon of ${address}`
                    }
                  ) : /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
                    "div",
                    {
                      className: "tl-hyperlink__icon",
                      style: {
                        mask: `url("${import_icons_editor.LINK_ICON}") center 100% / 100% no-repeat`,
                        WebkitMask: `url("${import_icons_editor.LINK_ICON}") center 100% / 100% no-repeat`
                      }
                    }
                  ),
                  /* @__PURE__ */ (0, import_jsx_runtime.jsx)("span", { children: address })
                ]
              }
            )
          ] })
        ]
      }
    ) });
  }
  indicator(shape) {
    return /* @__PURE__ */ (0, import_jsx_runtime.jsx)(
      "rect",
      {
        width: (0, import_editor.toDomPrecision)(shape.props.w),
        height: (0, import_editor.toDomPrecision)(shape.props.h),
        rx: "6",
        ry: "6"
      }
    );
  }
  onBeforeCreate = (next) => {
    return getBookmarkSize(this.editor, next);
  };
  onBeforeUpdate = (prev, shape) => {
    if (prev.props.url !== shape.props.url) {
      if (!import_editor.T.linkUrl.isValid(shape.props.url)) {
        return { ...shape, props: { ...shape.props, url: prev.props.url } };
      } else {
        updateBookmarkAssetOnUrlChange(this.editor, shape);
      }
    }
    if (prev.props.assetId !== shape.props.assetId) {
      return getBookmarkSize(this.editor, shape);
    }
  };
}
function getBookmarkSize(editor, shape) {
  const asset = shape.props.assetId ? editor.getAsset(shape.props.assetId) : null;
  let h = BOOKMARK_HEIGHT;
  if (asset) {
    if (!asset.props.image) {
      if (!asset.props.title) {
        h = BOOKMARK_JUST_URL_HEIGHT;
      } else {
        h = SHORT_BOOKMARK_HEIGHT;
      }
    }
  }
  return {
    ...shape,
    props: {
      ...shape.props,
      h
    }
  };
}
const getHumanReadableAddress = (shape) => {
  try {
    const url = new URL(shape.props.url);
    return url.hostname.replace(/^www\./, "");
  } catch (e) {
    return shape.props.url;
  }
};
function updateBookmarkAssetOnUrlChange(editor, shape) {
  const { url } = shape.props;
  const assetId = import_editor.AssetRecordType.createId((0, import_editor.getHashForString)(url));
  if (editor.getAsset(assetId)) {
    if (shape.props.assetId !== assetId) {
      editor.updateShapes([
        {
          id: shape.id,
          type: shape.type,
          props: { assetId }
        }
      ]);
    }
  } else {
    editor.updateShapes([
      {
        id: shape.id,
        type: shape.type,
        props: { assetId: null }
      }
    ]);
    createBookmarkAssetOnUrlChange(editor, shape);
  }
}
const createBookmarkAssetOnUrlChange = (0, import_editor.debounce)(async (editor, shape) => {
  if (editor.isDisposed) return;
  const { url } = shape.props;
  const asset = await editor.getAssetForExternalContent({ type: "url", url });
  if (!asset) {
    return;
  }
  editor.run(() => {
    editor.createAssets([asset]);
    editor.updateShapes([
      {
        id: shape.id,
        type: shape.type,
        props: { assetId: asset.id }
      }
    ]);
  });
}, 500);
//# sourceMappingURL=BookmarkShapeUtil.js.map
